-- 6_onTouched
    
function setup()
    -- prepare any object with x,y,w,h fields, here a button
    local txt = "Sometime you just want to get std Codea touch events"
    button = {
    x = WIDTH/2,
    y = HEIGHT/2,
    w = WIDTH/4,
    h = HEIGHT/4,
    txt = txt,
    color = color(255, 190, 0, 255), -- button color in false state
    }
    -- ############### and add a Sensor to it  #################
    button.sensor = Sensor{ parent=button, xywhMode=RADIUS }
    button.sensor:onTouched( function(event)
        local t = event.touch
        local str = "x= "..tostring(t.x).." y= "..tostring(t.y)
        button.txt = txt .. "\n" .. str
        if t.state==ENDED then button.txt = txt end
    end)
    -- ############### #################  #################
end
function touched(t)
    -- ######### add this in your touched function #########
    if button.sensor:touched(t) then return true end
end
function draw()
    noStroke()
    background(178, 178, 178, 255)     
    fill(button.color)
    rectMode(RADIUS)
    rect(button.x,button.y,button.w,button.h)
    fill(57, 57, 57, 255)         -- set color for text
    fontSize(25)            -- set font size
    textAlign(CENTER)
    textWrapWidth(button.w*1.8)
    text(button.txt,button.x,button.y)       -- draw text on screen)      
end
